define(['Portal', 'backbone', 'marionette', 'jquery', 'underscore'], function (Portal, Backbone, Marionette, $, _) {
	'use strict';

	Portal.module('WoundCareApplet', function (WoundCareApplet, Portal, Backbone, Marionette, $, _) {

		WoundCareApplet.RiskFactorsModel =  Backbone.Model.extend({
			initialize: function() {
				this.url = WoundCareApplet.resources.get('skin-assessment').get('href');
			},
			formatDate: function(str) {
				var splitt = str.split('.')[0].replace('T', ' ').split('-');
				return splitt[1] + '/' + splitt[2].split(':')[0] + ':' + splitt[2].split(':')[1];
			},
			parse: function(response) {
				if (response.pastRiskFactorAssessment && response.pastRiskFactorAssessment.updateDate)
					response.pastRiskFactorAssessment.updateDate = this.formatDate(response.pastRiskFactorAssessment.updateDate);

				return response;
			}
		});
	});
});